(function( $ ){
	$.widget("webucator.collapsify", $.mobile.widget, {
		//define a hash of options with default values for parameters, if not supplied by the caller
		options: {
			datatheme: 'a',
			openindex: null
		},
		//a constructor for the plugin:
		_create: function() {
			//for the element the plugin is called upon, set the "data-theme" attribute to the "datatheme" parameter value (defaulting to 'a' if not otherwise set)
			this.element.attr('data-role','collapsible-set').attr('data-theme',this.options.datatheme);
			//find all images contained within the element being acted upon
			this.images = this.element.children();
			//set variable "openindex" equal to the value of the "openindex" parameter
			var openindex = this.options.openindex;
			//for each image, wrap the image in a "div" with attribute "data-role" with value "collapsible" , add an "h2" whose text is the "title" attribute of the image, and add a paragraph whose text is the "alt" attribute of the image
			this.images.each(function(index) {
				$(this).wrap('<div data-role="collapsible"' + (openindex == index ? ' data-collapsed="false"' : '') + ' />').before('<h2>' + $(this).attr('title') +'</h2>').after('<p>' + $(this).attr('alt') + '</p>');
			});
			this.element.trigger('create');
		},
		_setOption: function(key, value) {
			//if the calling code specifies parameters, set the relevant key from the "options" hash to have the specified value
			this.options[key] = value;
			this._super( "_setOption", key, value );
		},
	});
})( jQuery );